package myBean;

import java.io.*;

public class ListFile {
	String root;
	String curDir;
	
	public ListFile() {
	}
	
	public void setRoot(String root) {
		curDir = root;
		this.root = root;
	}
	
	public String getRoot() {
		return root;
	}
	
	public void listFiles(Writer out, String path) throws IOException{
		if(path == null)
			path = root;
		else
			path = curDir+File.separator+path;
		File f = new File(path);
		if(f.isDirectory())
			curDir = path;
		File []files = f.listFiles();
		if(files == null) {
			return;
		}
		
		for(int i=0; i<files.length; i++) {
			out.write("<br>");
			String p = files[i].getPath();
			p = p.substring(p.lastIndexOf(File.separator)+1);
			if(files[i].isFile()) {
				out.write(p+"\r\n");
			}else if(files[i].isDirectory()){
				out.write("<a href=\"list_file.jsp?dir="+p+"\">"+p+"</a>\r\n");
			}else {
			}
		}
		out.flush();
	}
	
/*	public static void main(String []args) {
		try {
			PrintWriter out = new PrintWriter(System.out);
			ListFile list = new ListFile();
			list.setRoot("E:\\test\\DateAgenda");
			list.listFiles(out, null);
		}catch(IOException e) {
			System.out.println(e.getMessage());
		}
	} 
*/
}
